<?php

/*
* Title                   : Booking System PRO (WordPress Plugin)
* Version                 : 2.0
* File                    : config.php
* File Version            : 1.0.2
* Created / Last Modified : 03 August 2014
* Author                  : Dot on Paper
* Copyright               : © 2012 Dot on Paper
* Website                 : http://www.dotonpaper.net
* Description             : Booking System PRO configuration file.
*/

// ***************************************************************************** Begin general defaults

    define('DOPBSP_CONFIG_DATABASE_VERSION', 2.155); // Database version. It will update your current database structure if version is bigger than your current one.
    define('DOPBSP_CONFIG_INIT_DATABASE', false); // Set to "true" if you want to update database structure at each action.
    define('DOPBSP_CONFIG_REPAIR_TRANSLATION_DATABASE', false); // Set to "true" to repair translation database. All your previous translation will be replace.
    define('DOPBSP_CONFIG_DELETE_DATA_ON_DELETE', true);  // Set to "true" if you want to delete all data when you delete the plugin from admin.
    
// ***************************************************************************** End general defaults
    
    
// ***************************************************************************** Begin translation defaults

    define('DOPBSP_CONFIG_TRANSLATION_LANGUAGES_TO_INSTALL', 'en'); // Set the languages you want to install. Add the abbreviations separated by commas.
    define('DOPBSP_CONFIG_TRANSLATION_DEFAULT_LANGUAGE', 'en'); // Set default language.
    
// ***************************************************************************** End translation defaults
    
    
// ***************************************************************************** Begin users permissions defaults

    define('DOPBSP_CONFIG_USERS_PERMISSIONS_ADMINISTRATORS', 0); // Set to "1" to allow administrators to view all calendars by default. "0" to not allow.
    define('DOPBSP_CONFIG_USERS_PERMISSIONS_AUTHORS', 0); // Set to "1" to allow authors to create calendars by default. "0" to not allow.
    define('DOPBSP_CONFIG_USERS_PERMISSIONS_CONTRIBUTORS', 0); // Set to "1" to allow contributors to create calendars by default. "0" to not allow.
    define('DOPBSP_CONFIG_USERS_PERMISSIONS_EDITORS', 0); // Set to "1" to allow editors to create calendars by default. "0" to not allow.
    define('DOPBSP_CONFIG_USERS_PERMISSIONS_SUBSCRIBERS', 0); // Set to "1" to allow subscribers to create calendars by default. "0" to not allow.
    define('DOPBSP_CONFIG_USERS_PERMISSIONS_OTHERS', 0); // Set to "1" to allow other user roles to create calendars by default. "0" to not allow.
    
    define('DOPBSP_CONFIG_USERS_PERMISSIONS_CUSTOM_POSTS_ADMINISTRATORS', 1); // Set to "1" to allow administrator to create custom posts by default. "0" to not allow.
    define('DOPBSP_CONFIG_USERS_PERMISSIONS_CUSTOM_POSTS_AUTHORS', 1); // Set to "1" to allow authors to create custom posts by default. "0" to not allow.
    define('DOPBSP_CONFIG_USERS_PERMISSIONS_CUSTOM_POSTS_CONTRIBUTORS', 1); // Set to "1" to allow contributors to create custom posts by default. "0" to not allow.
    define('DOPBSP_CONFIG_USERS_PERMISSIONS_CUSTOM_POSTS_EDITORS', 1); // Set to "1" to allow editors to create custom posts by default. "0" to not allow.
    define('DOPBSP_CONFIG_USERS_PERMISSIONS_CUSTOM_POSTS_SUBSCRIBERS', 1); // Set to "1" to allow subscribers to create custom posts by default. "0" to not allow.
    define('DOPBSP_CONFIG_USERS_PERMISSIONS_CUSTOM_POSTS_OTHERS', 1); // Set to "1" to allow other user roles to create custom posts by default. "0" to not allow.
    
// ***************************************************************************** End users permissions defaults
    

// ***************************************************************************** Begin custom post type defaults
    
    define('DOPBSP_CONFIG_CUSTOM_POSTS_SLUG', 'booking-system'); // Set Custom post type slug.
    define('DOPBSP_CONFIG_CUSTOM_POSTS_OVERWRITE_POSTS_LOOP', false); // Set to "true" if you want to add booking system custom posts in blog posts.
    define('DOPBSP_CONFIG_CUSTOM_POSTS_NOT_ALLOWED_POST_TYPES_IN_LOOP', 'page,attachment,nav_menu_item,revision'); // The slugs of the post types, separated by comma, that will not appear in blog posts.
    
// ***************************************************************************** End custom post type defaults   
    
    
// ***************************************************************************** Begin databese defaults    
    
    define('DOPBSP_CONFIG_DATABASE_COLLATION', 'utf8_unicode_ci'); // Database collation.
    
// Calendars    
    define('DOPBSP_CONFIG_DATABASE_CALENDARS_DEFAULT_USER_ID', 0);
    define('DOPBSP_CONFIG_DATABASE_CALENDARS_DEFAULT_POST_ID', 0);
    define('DOPBSP_CONFIG_DATABASE_CALENDARS_DEFAULT_NAME', '');
    define('DOPBSP_CONFIG_DATABASE_CALENDARS_DEFAULT_MIN_PRICE', 0);
    define('DOPBSP_CONFIG_DATABASE_CALENDARS_DEFAULT_MAX_PRICE', 0);
    define('DOPBSP_CONFIG_DATABASE_CALENDARS_DEFAULT_AVAILABILITY', ''); // Type TEXT

// Coupons
    define('DOPBSP_CONFIG_DATABASE_COUPONS_DEFAULT_USER_ID', 0);
    define('DOPBSP_CONFIG_DATABASE_COUPONS_DEFAULT_NAME', '');
    define('DOPBSP_CONFIG_DATABASE_COUPONS_DEFAULT_CODE', '');
    define('DOPBSP_CONFIG_DATABASE_COUPONS_DEFAULT_START_TIME_LAPSE', '');
    define('DOPBSP_CONFIG_DATABASE_COUPONS_DEFAULT_END_TIME_LAPSE', '');
    define('DOPBSP_CONFIG_DATABASE_COUPONS_DEFAULT_START_DATE', '');
    define('DOPBSP_CONFIG_DATABASE_COUPONS_DEFAULT_END_DATE', '');
    define('DOPBSP_CONFIG_DATABASE_COUPONS_DEFAULT_START_HOUR', '');
    define('DOPBSP_CONFIG_DATABASE_COUPONS_DEFAULT_END_HOUR', '');
    define('DOPBSP_CONFIG_DATABASE_COUPONS_DEFAULT_NO_COUPONS', '');
    define('DOPBSP_CONFIG_DATABASE_COUPONS_DEFAULT_OPERATION', '+');
    define('DOPBSP_CONFIG_DATABASE_COUPONS_DEFAULT_PRICE', 0);
    define('DOPBSP_CONFIG_DATABASE_COUPONS_DEFAULT_PRICE_TYPE', 'fixed');
    define('DOPBSP_CONFIG_DATABASE_COUPONS_DEFAULT_PRICE_BY', 'once');
    define('DOPBSP_CONFIG_DATABASE_COUPONS_DEFAULT_TRANSLATION', ''); // Type TEXT

// Days    
    define('DOPBSP_CONFIG_DATABASE_DAYS_DEFAULT_CALENDAR_ID', 0);
    define('DOPBSP_CONFIG_DATABASE_DAYS_DEFAULT_DAY', '');
    define('DOPBSP_CONFIG_DATABASE_DAYS_DEFAULT_YEAR', date('Y'));
    define('DOPBSP_CONFIG_DATABASE_DAYS_DEFAULT_DATA', ''); // Type TEXT
    
// Discounts
    define('DOPBSP_CONFIG_DATABASE_DISCOUTS_DEFAULT_USER_ID', 0);
    define('DOPBSP_CONFIG_DATABASE_DISCOUNTS_DEFAULT_NAME', '');
    
// Discounts items    
    define('DOPBSP_CONFIG_DATABASE_DISCOUNTS_ITEMS_DEFAULT_DISCOUNT_ID', 0);
    define('DOPBSP_CONFIG_DATABASE_DISCOUNTS_ITEMS_DEFAULT_POSITION', 0);
    define('DOPBSP_CONFIG_DATABASE_DISCOUNTS_ITEMS_DEFAULT_START_TIME_LAPSE', '');
    define('DOPBSP_CONFIG_DATABASE_DISCOUNTS_ITEMS_DEFAULT_END_TIME_LAPSE', '');
    define('DOPBSP_CONFIG_DATABASE_DISCOUNTS_ITEMS_DEFAULT_OPERATION', '-');
    define('DOPBSP_CONFIG_DATABASE_DISCOUNTS_ITEMS_DEFAULT_PRICE', 0);
    define('DOPBSP_CONFIG_DATABASE_DISCOUNTS_ITEMS_DEFAULT_PRICE_TYPE', 'percent');
    define('DOPBSP_CONFIG_DATABASE_DISCOUNTS_ITEMS_DEFAULT_PRICE_BY', 'once');
    define('DOPBSP_CONFIG_DATABASE_DISCOUNTS_ITEMS_DEFAULT_TRANSLATION', ''); // Type TEXT
    
// Discounts items rules  
    define('DOPBSP_CONFIG_DATABASE_DISCOUNTS_ITEMS_RULES_DEFAULT_DISCOUNT_ITEM_ID', 0);
    define('DOPBSP_CONFIG_DATABASE_DISCOUNTS_ITEMS_RULES_DEFAULT_POSITION', 0);
    define('DOPBSP_CONFIG_DATABASE_DISCOUNTS_ITEMS_RULES_DEFAULT_START_DATE', '');
    define('DOPBSP_CONFIG_DATABASE_DISCOUNTS_ITEMS_RULES_DEFAULT_END_DATE', '');
    define('DOPBSP_CONFIG_DATABASE_DISCOUNTS_ITEMS_RULES_DEFAULT_START_HOUR', '');
    define('DOPBSP_CONFIG_DATABASE_DISCOUNTS_ITEMS_RULES_DEFAULT_END_HOUR', '');
    define('DOPBSP_CONFIG_DATABASE_DISCOUNTS_ITEMS_RULES_DEFAULT_OPERATION', '-');
    define('DOPBSP_CONFIG_DATABASE_DISCOUNTS_ITEMS_RULES_DEFAULT_PRICE', 0);
    define('DOPBSP_CONFIG_DATABASE_DISCOUNTS_ITEMS_RULES_DEFAULT_PRICE_TYPE', 'percent');
    define('DOPBSP_CONFIG_DATABASE_DISCOUNTS_ITEMS_RULES_DEFAULT_PRICE_BY', 'once');
    
// Emails
    define('DOPBSP_CONFIG_DATABASE_EMAILS_DEFAULT_USER_ID', 0);
    define('DOPBSP_CONFIG_DATABASE_EMAILS_DEFAULT_NAME', '');
    
// Emails translation    
    define('DOPBSP_CONFIG_DATABASE_EMAILS_TRANSLATION_DEFAULT_EMAIL_ID', 0);
    define('DOPBSP_CONFIG_DATABASE_EMAILS_TRANSLATION_DEFAULT_TEMPLATE', '');
    define('DOPBSP_CONFIG_DATABASE_EMAILS_TRANSLATION_DEFAULT_SUBJECT', ''); // Type TEXT
    define('DOPBSP_CONFIG_DATABASE_EMAILS_TRANSLATION_DEFAULT_MESSAGE', ''); // Type TEXT
    
// Extras
    define('DOPBSP_CONFIG_DATABASE_EXTRAS_DEFAULT_USER_ID', 0);
    define('DOPBSP_CONFIG_DATABASE_EXTRAS_DEFAULT_NAME', '');
               
// Extras groups    
    define('DOPBSP_CONFIG_DATABASE_EXTRAS_GROUPS_DEFAULT_EXTRA_ID', 0);
    define('DOPBSP_CONFIG_DATABASE_EXTRAS_GROUPS_DEFAULT_POSITION', 0);
    define('DOPBSP_CONFIG_DATABASE_EXTRAS_GROUPS_DEFAULT_MULTIPLE_SELECT', 'false');
    define('DOPBSP_CONFIG_DATABASE_EXTRAS_GROUPS_DEFAULT_REQUIRED', 'false');
    define('DOPBSP_CONFIG_DATABASE_EXTRAS_GROUPS_DEFAULT_TRANSLATION', ''); // Type TEXT
               
// Extras groups items     
    define('DOPBSP_CONFIG_DATABASE_EXTRAS_GROUPS_ITEMS_DEFAULT_GROUP_ID', 0);
    define('DOPBSP_CONFIG_DATABASE_EXTRAS_GROUPS_ITEMS_DEFAULT_POSITION', 0);
    define('DOPBSP_CONFIG_DATABASE_EXTRAS_GROUPS_ITEMS_DEFAULT_OPERATION', '+');
    define('DOPBSP_CONFIG_DATABASE_EXTRAS_GROUPS_ITEMS_DEFAULT_PRICE', 0);
    define('DOPBSP_CONFIG_DATABASE_EXTRAS_GROUPS_ITEMS_DEFAULT_PRICE_TYPE', 'fixed');
    define('DOPBSP_CONFIG_DATABASE_EXTRAS_GROUPS_ITEMS_DEFAULT_PRICE_BY', 'once');
    define('DOPBSP_CONFIG_DATABASE_EXTRAS_GROUPS_ITEMS_DEFAULT_TRANSLATION', ''); // Type TEXT

// Fees
    define('DOPBSP_CONFIG_DATABASE_FEES_DEFAULT_USER_ID', 0);
    define('DOPBSP_CONFIG_DATABASE_FEES_DEFAULT_NAME', '');
    define('DOPBSP_CONFIG_DATABASE_FEES_DEFAULT_OPERATION', '+');
    define('DOPBSP_CONFIG_DATABASE_FEES_DEFAULT_PRICE', 0);
    define('DOPBSP_CONFIG_DATABASE_FEES_DEFAULT_PRICE_TYPE', 'fixed');
    define('DOPBSP_CONFIG_DATABASE_FEES_DEFAULT_PRICE_BY', 'once');
    define('DOPBSP_CONFIG_DATABASE_FEES_DEFAULT_INCLUDED', 'true');
    define('DOPBSP_CONFIG_DATABASE_FEES_DEFAULT_EXTRAS', 'true');
    define('DOPBSP_CONFIG_DATABASE_FEES_DEFAULT_CART', 'true');
    define('DOPBSP_CONFIG_DATABASE_FEES_DEFAULT_TRANSLATION', ''); // Type TEXT
    
// Forms
    define('DOPBSP_CONFIG_DATABASE_FORMS_DEFAULT_USER_ID', 0);
    define('DOPBSP_CONFIG_DATABASE_FORMS_DEFAULT_NAME', '');
    define('DOPBSP_CONFIG_DATABASE_FORMS_DEFAULT_LABEL', ''); // Type TEXT
    
// Forms fields    
    define('DOPBSP_CONFIG_DATABASE_FORMS_FIELDS_DEFAULT_FORM_ID', 0);
    define('DOPBSP_CONFIG_DATABASE_FORMS_FIELDS_DEFAULT_LABEL', ''); // Type TEXT
    define('DOPBSP_CONFIG_DATABASE_FORMS_FIELDS_DEFAULT_TYPE', '');
    define('DOPBSP_CONFIG_DATABASE_FORMS_FIELDS_DEFAULT_POSITION', 0);
    define('DOPBSP_CONFIG_DATABASE_FORMS_FIELDS_DEFAULT_MULTIPLE_SELECT', 'false');
    define('DOPBSP_CONFIG_DATABASE_FORMS_FIELDS_DEFAULT_ALLOWED_CHARACTERS', ''); // Type TEXT
    define('DOPBSP_CONFIG_DATABASE_FORMS_FIELDS_DEFAULT_SIZE', 0);
    define('DOPBSP_CONFIG_DATABASE_FORMS_FIELDS_DEFAULT_IS_EMAIL', 'false');
    define('DOPBSP_CONFIG_DATABASE_FORMS_FIELDS_DEFAULT_REQUIRED', 'false');
    define('DOPBSP_CONFIG_DATABASE_FORMS_FIELDS_DEFAULT_ADD_TO_DAY_HOUR_INFO', 'false');
    define('DOPBSP_CONFIG_DATABASE_FORMS_FIELDS_DEFAULT_ADD_TO_DAY_HOUR_BODY', 'false');
    define('DOPBSP_CONFIG_DATABASE_FORMS_FIELDS_DEFAULT_INFO', ''); // Type TEXT
    
// Forms select options    
    define('DOPBSP_CONFIG_DATABASE_FORMS_SELECT_OPTIONS_DEFAULT_FIELD_ID', 0);
    define('DOPBSP_CONFIG_DATABASE_FORMS_SELECT_OPTIONS_DEFAULT_LABEL', ''); // Type TEXT
    define('DOPBSP_CONFIG_DATABASE_FORMS_SELECT_OPTIONS_DEFAULT_POSITION', 0);

// Languages 
    define('DOPBSP_CONFIG_DATABASE_LANGUAGES_DEFAULT_NAME', '');
    define('DOPBSP_CONFIG_DATABASE_LANGUAGES_DEFAULT_CODE', '');
    define('DOPBSP_CONFIG_DATABASE_LANGUAGES_DEFAULT_ENABLED', 'false');
   
// Reservations    
    define('DOPBSP_CONFIG_DATABASE_RESERVATIONS_DEFAULT_CALENDAR_ID', 0);
    define('DOPBSP_CONFIG_DATABASE_RESERVATIONS_DEFAULT_LANGUAGE', 'en');
    define('DOPBSP_CONFIG_DATABASE_RESERVATIONS_DEFAULT_CURRENCY', '$');
    define('DOPBSP_CONFIG_DATABASE_RESERVATIONS_DEFAULT_CURRENCY_CODE', 'USD');
    
    define('DOPBSP_CONFIG_DATABASE_RESERVATIONS_DEFAULT_CHECK_IN', '');
    define('DOPBSP_CONFIG_DATABASE_RESERVATIONS_DEFAULT_CHECK_OUT', '');
    define('DOPBSP_CONFIG_DATABASE_RESERVATIONS_DEFAULT_START_HOUR', '');
    define('DOPBSP_CONFIG_DATABASE_RESERVATIONS_DEFAULT_END_HOUR', '');
    define('DOPBSP_CONFIG_DATABASE_RESERVATIONS_DEFAULT_NO_ITEMS', 1);
    define('DOPBSP_CONFIG_DATABASE_RESERVATIONS_DEFAULT_PRICE', 0);
    define('DOPBSP_CONFIG_DATABASE_RESERVATIONS_DEFAULT_PRICE_TOTAL', 0);
    
    define('DOPBSP_CONFIG_DATABASE_RESERVATIONS_DEFAULT_EXTRAS', ''); // Type TEXT
    define('DOPBSP_CONFIG_DATABASE_RESERVATIONS_DEFAULT_EXTRAS_PRICE', 0);
    define('DOPBSP_CONFIG_DATABASE_RESERVATIONS_DEFAULT_DISCOUNT', ''); // Type TEXT
    define('DOPBSP_CONFIG_DATABASE_RESERVATIONS_DEFAULT_DISCOUNT_PRICE', 0); 
    define('DOPBSP_CONFIG_DATABASE_RESERVATIONS_DEFAULT_COUPON', ''); // Type TEXT
    define('DOPBSP_CONFIG_DATABASE_RESERVATIONS_DEFAULT_COUPON_PRICE', 0);
    define('DOPBSP_CONFIG_DATABASE_RESERVATIONS_DEFAULT_FEES', ''); // Type TEXT
    define('DOPBSP_CONFIG_DATABASE_RESERVATIONS_DEFAULT_FEES_PRICE', 0);
    define('DOPBSP_CONFIG_DATABASE_RESERVATIONS_DEFAULT_DEPOSIT', ''); // Type TEXT
    define('DOPBSP_CONFIG_DATABASE_RESERVATIONS_DEFAULT_DEPOSIT_PRICE', 0);
    
    define('DOPBSP_CONFIG_DATABASE_RESERVATIONS_DEFAULT_DAYS_HOURS_HISTORY', ''); // Type TEXT
    define('DOPBSP_CONFIG_DATABASE_RESERVATIONS_DEFAULT_FORM', ''); // Type TEXT
    define('DOPBSP_CONFIG_DATABASE_RESERVATIONS_DEFAULT_EMAIL', '');
    define('DOPBSP_CONFIG_DATABASE_RESERVATIONS_DEFAULT_STATUS', 'pending');
    define('DOPBSP_CONFIG_DATABASE_RESERVATIONS_DEFAULT_PAYMENT_METHOD', 'default');
    define('DOPBSP_CONFIG_DATABASE_RESERVATIONS_DEFAULT_TRANSACTION_ID', '');
    define('DOPBSP_CONFIG_DATABASE_RESERVATIONS_DEFAULT_TOKEN', '');
    define('DOPBSP_CONFIG_DATABASE_RESERVATIONS_DEFAULT_DATE_CREATED', ''); // Type DATE

// Rules
    define('DOPBSP_CONFIG_DATABASE_RULES_DEFAULT_USER_ID', 0);
    define('DOPBSP_CONFIG_DATABASE_RULES_DEFAULT_NAME', '');
    define('DOPBSP_CONFIG_DATABASE_RULES_DEFAULT_TIME_LAPSE_MIN', 0);
    define('DOPBSP_CONFIG_DATABASE_RULES_DEFAULT_TIME_LAPSE_MAX', 0);
    
// Settings    
    define('DOPBSP_CONFIG_DATABASE_SETTINGS_DEFAULT_CALENDAR_ID', 0);
    define('DOPBSP_CONFIG_DATABASE_SETTINGS_DEFAULT_DATE_TYPE', 1);
    define('DOPBSP_CONFIG_DATABASE_SETTINGS_DEFAULT_TEMPLATE', 'default');
    define('DOPBSP_CONFIG_DATABASE_SETTINGS_DEFAULT_BOOKING_STOP', 0);
    define('DOPBSP_CONFIG_DATABASE_SETTINGS_DEFAULT_MONTHS_NO', 1);
    define('DOPBSP_CONFIG_DATABASE_SETTINGS_DEFAULT_VIEW_ONLY', 'false');
    define('DOPBSP_CONFIG_DATABASE_SETTINGS_DEFAULT_POST_ID', 0);
    define('DOPBSP_CONFIG_DATABASE_SETTINGS_DEFAULT_MAX_YEAR', date('Y'));
    
    define('DOPBSP_CONFIG_DATABASE_SETTINGS_DEFAULT_CURRENCY', 'USD');
    define('DOPBSP_CONFIG_DATABASE_SETTINGS_DEFAULT_CURRENCY_POSITION', 'before');
    
    define('DOPBSP_CONFIG_DATABASE_SETTINGS_DEFAULT_DAYS_AVAILABLE', 'true,true,true,true,true,true,true');
    define('DOPBSP_CONFIG_DATABASE_SETTINGS_DEFAULT_DAYS_DETAILS_FROM_HOURS', 'true');
    define('DOPBSP_CONFIG_DATABASE_SETTINGS_DEFAULT_DAYS_FIRST', 1);
    define('DOPBSP_CONFIG_DATABASE_SETTINGS_DEFAULT_DAYS_MORNING_CHECK_OUT', 'false');
    define('DOPBSP_CONFIG_DATABASE_SETTINGS_DEFAULT_DAYS_MULTIPLE_SELECT', 'true');
    
    define('DOPBSP_CONFIG_DATABASE_SETTINGS_DEFAULT_HOURS_ADD_LAST_HOUR_TO_TOTAL_PRICE', 'true');
    define('DOPBSP_CONFIG_DATABASE_SETTINGS_DEFAULT_HOURS_AMPM', 'false');
    define('DOPBSP_CONFIG_DATABASE_SETTINGS_DEFAULT_HOURS_DEFINITIONS', ''); // Type TEXT
    define('DOPBSP_CONFIG_DATABASE_SETTINGS_DEFAULT_HOURS_ENABLED', 'false');
    define('DOPBSP_CONFIG_DATABASE_SETTINGS_DEFAULT_HOURS_INFO_ENABLED', 'true');
    define('DOPBSP_CONFIG_DATABASE_SETTINGS_DEFAULT_HOURS_INTERVAL_ENABLED', 'false');
    define('DOPBSP_CONFIG_DATABASE_SETTINGS_DEFAULT_HOURS_MULTIPLE_SELECT', 'true');
    
    define('DOPBSP_CONFIG_DATABASE_SETTINGS_DEFAULT_SIDEBAR_NO_ITEMS_ENABLED', 'true');
    define('DOPBSP_CONFIG_DATABASE_SETTINGS_DEFAULT_SIDEBAR_STYLE', 1);
    
    define('DOPBSP_CONFIG_DATABASE_SETTINGS_DEFAULT_RULE', 0);
    define('DOPBSP_CONFIG_DATABASE_SETTINGS_DEFAULT_EXTRA', 0);
    define('DOPBSP_CONFIG_DATABASE_SETTINGS_DEFAULT_CART_ENABLED', 'false');
    define('DOPBSP_CONFIG_DATABASE_SETTINGS_DEFAULT_DISCOUNT', 0);
    define('DOPBSP_CONFIG_DATABASE_SETTINGS_DEFAULT_FEES', '');
    define('DOPBSP_CONFIG_DATABASE_SETTINGS_DEFAULT_COUPON', 0);
    
    define('DOPBSP_CONFIG_DATABASE_SETTINGS_DEFAULT_DEPOSIT', 0);
    define('DOPBSP_CONFIG_DATABASE_SETTINGS_DEFAULT_DEPOSIT_TYPE', 'percent');
    
    define('DOPBSP_CONFIG_DATABASE_SETTINGS_DEFAULT_FORM', 1);
    
    define('DOPBSP_CONFIG_DATABASE_SETTINGS_DEFAULT_TERMS_AND_CONDITIONS_ENABLED', 'false');
    define('DOPBSP_CONFIG_DATABASE_SETTINGS_DEFAULT_TERMS_AND_CONDITIONS_LINK', '');
    
// Settings notifications.  
    define('DOPBSP_CONFIG_DATABASE_SETTINGS_NOTIFICATIONS_DEFAULT_CALENDAR_ID', 0);  
    define('DOPBSP_CONFIG_DATABASE_SETTINGS_NOTIFICATIONS_DEFAULT_TEMPLATES', 1);
    define('DOPBSP_CONFIG_DATABASE_SETTINGS_NOTIFICATIONS_DEFAULT_METHOD', 'mailer');
    define('DOPBSP_CONFIG_DATABASE_SETTINGS_NOTIFICATIONS_DEFAULT_EMAIL', '');
    define('DOPBSP_CONFIG_DATABASE_SETTINGS_NOTIFICATIONS_DEFAULT_EMAIL_REPLY', '');
    define('DOPBSP_CONFIG_DATABASE_SETTINGS_NOTIFICATIONS_DEFAULT_EMAIL_NAME', '');
    
    define('DOPBSP_CONFIG_DATABASE_SETTINGS_NOTIFICATIONS_DEFAULT_SMTP_HOST_NAME', '');
    define('DOPBSP_CONFIG_DATABASE_SETTINGS_NOTIFICATIONS_DEFAULT_SMTP_HOST_PORT', 25);
    define('DOPBSP_CONFIG_DATABASE_SETTINGS_NOTIFICATIONS_DEFAULT_SMTP_SSL', 'false');
    define('DOPBSP_CONFIG_DATABASE_SETTINGS_NOTIFICATIONS_DEFAULT_SMTP_USER', '');
    define('DOPBSP_CONFIG_DATABASE_SETTINGS_NOTIFICATIONS_DEFAULT_SMTP_PASSWORD', '');
    
    define('DOPBSP_CONFIG_DATABASE_SETTINGS_NOTIFICATIONS_DEFAULT_SEND_BOOK_ADMIN', 'true');
    define('DOPBSP_CONFIG_DATABASE_SETTINGS_NOTIFICATIONS_DEFAULT_SEND_BOOK_USER', 'true');
    define('DOPBSP_CONFIG_DATABASE_SETTINGS_NOTIFICATIONS_DEFAULT_SEND_BOOK_WITH_APPROVAL_ADMIN', 'true');
    define('DOPBSP_CONFIG_DATABASE_SETTINGS_NOTIFICATIONS_DEFAULT_SEND_BOOK_WITH_APPROVAL_USER', 'true');
    define('DOPBSP_CONFIG_DATABASE_SETTINGS_NOTIFICATIONS_DEFAULT_SEND_PAYPAL_ADMIN', 'true');
    define('DOPBSP_CONFIG_DATABASE_SETTINGS_NOTIFICATIONS_DEFAULT_SEND_PAYPAL_USER', 'true');
    define('DOPBSP_CONFIG_DATABASE_SETTINGS_NOTIFICATIONS_DEFAULT_SEND_APPROVED', 'true');
    define('DOPBSP_CONFIG_DATABASE_SETTINGS_NOTIFICATIONS_DEFAULT_SEND_CANCELED', 'true');
    define('DOPBSP_CONFIG_DATABASE_SETTINGS_NOTIFICATIONS_DEFAULT_SEND_REJECTED', 'true');
    
// Settings payment.
    define('DOPBSP_CONFIG_DATABASE_SETTINGS_PAYMENT_DEFAULT_CALENDAR_ID', 0);
    define('DOPBSP_CONFIG_DATABASE_SETTINGS_PAYMENT_DEFAULT_ARRIVAL_ENABLED', 'true');
    define('DOPBSP_CONFIG_DATABASE_SETTINGS_PAYMENT_DEFAULT_ARRIVAL_WITH_APPROVAL_ENABLED', 'false');
    define('DOPBSP_CONFIG_DATABASE_SETTINGS_PAYMENT_DEFAULT_REDIRECT', '');
    
    define('DOPBSP_CONFIG_DATABASE_SETTINGS_PAYMENT_DEFAULT_PAYPAL_ENABLED', 'false');
    define('DOPBSP_CONFIG_DATABASE_SETTINGS_PAYMENT_DEFAULT_PAYPAL_USERNAME', '');
    define('DOPBSP_CONFIG_DATABASE_SETTINGS_PAYMENT_DEFAULT_PAYPAL_PASSWORD', '');
    define('DOPBSP_CONFIG_DATABASE_SETTINGS_PAYMENT_DEFAULT_PAYPAL_SIGNATURE', '');
    define('DOPBSP_CONFIG_DATABASE_SETTINGS_PAYMENT_DEFAULT_PAYPAL_CREDIT_CARD', 'false');
    define('DOPBSP_CONFIG_DATABASE_SETTINGS_PAYMENT_DEFAULT_PAYPAL_SANDBOX_ENABLED', 'false');
    define('DOPBSP_CONFIG_DATABASE_SETTINGS_PAYMENT_DEFAULT_PAYPAL_REDIRECT', '');
    
// Translation
    define('DOPBSP_CONFIG_DATABASE_TRANSLATION_DEFAULT_KEY_DATA', '');
    define('DOPBSP_CONFIG_DATABASE_TRANSLATION_DEFAULT_LOCATION', 'backend');
    define('DOPBSP_CONFIG_DATABASE_TRANSLATION_DEFAULT_POSITION', 0);
    define('DOPBSP_CONFIG_DATABASE_TRANSLATION_DEFAULT_PARENT_KEY', '');
    define('DOPBSP_CONFIG_DATABASE_TRANSLATION_DEFAULT_TEXT_DATA', ''); // Type TEXT
    define('DOPBSP_CONFIG_DATABASE_TRANSLATION_DEFAULT_TRANSLATION', ''); // Type TEXT
    
// WooCommerce    
    define('DOPBSP_CONFIG_DATABASE_WOOCOMMERCE_DEFAULT_CART_KEY', '');
    define('DOPBSP_CONFIG_DATABASE_WOOCOMMERCE_DEFAULT_VARIATION_ID', 0);
    define('DOPBSP_CONFIG_DATABASE_WOOCOMMERCE_DEFAULT_PRODUCT_ID', 0);
    define('DOPBSP_CONFIG_DATABASE_WOOCOMMERCE_DEFAULT_CALENDAR_ID', 0);
    define('DOPBSP_CONFIG_DATABASE_WOOCOMMERCE_DEFAULT_LANGUAGE', '');
    define('DOPBSP_CONFIG_DATABASE_WOOCOMMERCE_DEFAULT_CURRENCY', '');
    define('DOPBSP_CONFIG_DATABASE_WOOCOMMERCE_DEFAULT_CURRENCY_CODE', '');
    define('DOPBSP_CONFIG_DATABASE_WOOCOMMERCE_DEFAULT_DATA', ''); // Type TEXT
    define('DOPBSP_CONFIG_DATABASE_WOOCOMMERCE_DEFAULT_DATE_CREATED', ''); // Type DATE
    
// ***************************************************************************** End databese defaults

    
// ***************************************************************************** Begin server requirements
    
    define('DOPBSP_CONFIG_SERVER_WORDPRESS_VERSION', '3.5'); // WordPress version
    define('DOPBSP_CONFIG_SERVER_WOOCOMMERCE_VERSION', '2.1.0'); // WooCommerce version
    define('DOPBSP_CONFIG_SERVER_PHP_VERSION', '5.1'); // PHP version
    define('DOPBSP_CONFIG_SERVER_MYSQL_VERSION', '5.0'); // MySQL version
    define('DOPBSP_CONFIG_SERVER_MEMORY_LIMIT', '2M'); // Memory limit
    define('DOPBSP_CONFIG_SERVER_MEMORY_LIMIT_WITH_WOOCOMMERCE', '64M'); // Memory limit with WooCommerce
    
// ***************************************************************************** End server requirements

    
// ***************************************************************************** Begin help defaults
    
    define('DOPBSP_CONFIG_HELP_DOCUMENTATION_URL', 'http://envato-help.dotonpaper.net/booking-system-wordpress-plugin/'); // Link to plugin documentation.
    
// ***************************************************************************** End help defaults