<?php

/*
* Title                   : Booking System Pro (WordPress Plugin)
* Version                 : 2.0
* File                    : includes/class-email.php
* File Version            : 1.0.1
* Created / Last Modified : 03 August 2014
* Author                  : Dot on Paper
* Copyright               : © 2012 Dot on Paper
* Website                 : http://www.dotonpaper.net
* Description             : Booking System PRO email PHP class.
*/
    
    if (!class_exists('DOPBSPNotifications')){
        class DOPBSPNotifications{
            /*
             * Constructor.
             */
            function DOPBSPNotifications(){
            }
            
            /*
             * Send email.
             * 
             * @param email_to (string): receiver email
             * @param email_from (string): sender email
             * @param email_reply (string): sender reply email
             * @param email_name (string): sender name
             * @param subject (string): email subject
             * @param message (string): email message
             * @param host_name (string): SMTP host name
             * @param host_port (string): SMTP host port
             * @param ssl (string): SMTP use secure authentication
             * @param user (string): SMTP user authentication
             * @param password (string): SMTP password authentication
             * @param method (string): the method used to send the email
             *                         "mail" send email with PHP mail function
             *                         "mailer" send email with Mailer
             *                         "smtp" send email with SMTP
             *                         "wp" send email with WordPress mail function
             * @param is_test (boolean): check if the email is sent for testing purposes
             */
            function send($email_to,
                          $email_from,
                          $email_reply,
                          $email_name,
                          $subject,
                          $message,
                          $host_name = '',
                          $host_port = 25,
                          $ssl = '',
                          $user = '',
                          $password = '',
                          $method = 'mailer',
                          $is_test = false){
                $email_reply = $email_reply == '' ? $email_from:$email_reply;
                $email_name = $email_name == '' ? $email_reply:$email_name;
                
                switch ($method){
                    case 'mail':
                        $this->sendMail($email_to,
                                        $email_from,
                                        $email_reply,
                                        $email_name,
                                        $subject,
                                        $message,
                                        $is_test);
                        break;
                    case 'smtp':
                        $this->sendSMTP($email_to,
                                        $email_from,
                                        $email_reply,
                                        $email_name,
                                        $subject,
                                        $message,
                                        $host_name,
                                        $host_port,
                                        $ssl,
                                        $user,
                                        $password,
                                        $is_test);
                        break;
                    case 'wp':
                        $this->sendWPMail($email_to,
                                          $email_from,
                                          $email_reply,
                                          $email_name,
                                          $subject,
                                          $message,
                                          $is_test);
                        break;
                    default:
                        $this->sendMailer($email_to,
                                          $email_from,
                                          $email_reply,
                                          $email_name,
                                          $subject,
                                          $message,
                                          $is_test);
                }
            }
            
            /*
             * Send email with PHP mail function.
             * 
             * @param email_to (string): receiver email
             * @param email_from (string): sender email
             * @param email_reply (string): sender reply email
             * @param email_name (string): sender name
             * @param subject (string): email subject
             * @param message (string): email message
             * @param is_test (boolean): check if the email is sent for testing purposes
             */
            function sendMail($email_to,
                              $email_from,
                              $email_reply,
                              $email_name,
                              $subject,
                              $message,
                              $is_test = false){    
                global $DOPBSP;
                            
                $headers = array();
                
                array_push($headers, 'Content-type: text/html; charset=utf-8'."\r\n");
                array_push($headers, 'MIME-Version: 1.1'."\r\n");
                array_push($headers, 'From: '.$email_name.' <'.$email_from.'>'."\r\n");
                array_push($headers, 'Reply-To: '.$email_name.' <'.$email_reply.'>');
        
                if (!mail($email_to, $subject, $message, implode('', $headers))){
                    if ($is_test){
                        echo $DOPBSP->text('SETTINGS_NOTIFICATIONS_TEST_ERROR');
                        die();
                    }
                }
                else{
                    if ($is_test){
                        echo 'success';
                        die();
                    }
                }
            }
            
            /*
             * Send email with Mailer.
             * 
             * @param email_to (string): receiver email
             * @param email_from (string): sender email
             * @param email_reply (string): sender reply email
             * @param email_name (string): sender name
             * @param subject (string): email subject
             * @param message (string): email message
             * @param is_test (boolean): check if the email is sent for testing purposes
             */
            function sendMailer($email_to,
                                $email_from,
                                $email_reply,
                                $email_name,
                                $subject,
                                $message,
                                $is_test = false){
                global $DOPBSP;
                
                $php_mailer = new PHPMailer();
                
                $php_mailer->CharSet = 'utf-8';
                $php_mailer->isMail();
                
                $emails_to = explode(',', $email_to);
                
                for ($i=0; $i<count($emails_to); $i++){
                    $php_mailer->addAddress($emails_to[$i]);
                }
                
                $php_mailer->From = $email_from;
                $php_mailer->FromName = $email_name;
                $php_mailer->addReplyTo($email_reply);
                $php_mailer->isHTML(true);

                $php_mailer->Subject = $subject;
                $php_mailer->Body = $message;

                if (!$php_mailer->send()){
                    if ($is_test){
                        echo $DOPBSP->text('SETTINGS_NOTIFICATIONS_TEST_ERROR').'<br />';
                        echo 'Mailer error: '.$php_mailer->ErrorInfo.'<br />';
                        echo $php_mailer->ErrorInfo;
                        die();
                    }
                    else{
                        $this->sendWPMail($email_to,
                                          $email_from,
                                          $email_reply,
                                          $email_name,
                                          $subject,
                                          $message);
                    }
                }
                else{
                    if ($is_test){
                        echo 'success';
                        die();
                    }
                }
            }
            
            /*
             * Send email with SMTP.
             * 
             * @param email_to (string): receiver email
             * @param email_from (string): sender email
             * @param email_reply (string): sender reply email
             * @param email_name (string): sender name
             * @param subject (string): email subject
             * @param message (string): email message
             * @param host_name (string): SMTP host name
             * @param host_port (string): SMTP host port
             * @param ssl (string): SMTP use secure authentication
             * @param user (string): SMTP user authentication
             * @param password (string): SMTP password authentication
             * @param is_test (boolean): check if the email is sent for testing purposes
             */
            function sendSMTP($email_to,
                              $email_from,
                              $email_reply,
                              $email_name,
                              $subject,
                              $message,
                              $host_name = '',
                              $host_port = 25,
                              $ssl = '',
                              $user = '',
                              $password = '',
                              $is_test = false){
                global $DOPBSP;
                
                $php_mailer = new PHPMailer();
                
                $php_mailer->CharSet = 'UTF-8';
                $php_mailer->isSMTP();
                $php_mailer->Host = $host_name;
                $php_mailer->Port = $host_port;
                $php_mailer->SMTPAuth = true;
                $php_mailer->SMTPSecure = $ssl == 'true' ? ($host_port == '587' ? 'tls':'ssl'):'';
                $php_mailer->Username = $user;
                $php_mailer->Password = $password;
                
                $emails_to = explode(',', $email_to);
                
                for ($i=0; $i<count($emails_to); $i++){
                    $php_mailer->addAddress($emails_to[$i]);
                }
                
                $php_mailer->From = $email_from;
                $php_mailer->FromName = $email_name;
                $php_mailer->addReplyTo($email_reply);
                $php_mailer->isHTML(true);

                $php_mailer->Subject = $subject;
                $php_mailer->Body = $message;

                if (!$php_mailer->send()){
                    if ($is_test){
                        echo $DOPBSP->text('SETTINGS_NOTIFICATIONS_TEST_ERROR').'<br />';
                        echo 'Mailer error: '.$php_mailer->ErrorInfo.'<br />';
                        echo $php_mailer->ErrorInfo;
                        die();
                    }
                    else{
                        $this->sendMailer($email_to,
                                          $email_from,
                                          $email_reply,
                                          $email_name,
                                          $subject,
                                          $message);
                    }
                }
                else{
                    if ($is_test){
                        echo 'success';
                        die();
                    }
                }
            }
            
            /*
             * Send email with WordPress mail function.
             * 
             * @param email_to (string): receiver email
             * @param email_from (string): sender email
             * @param email_reply (string): sender reply email
             * @param email_name (string): sender name
             * @param subject (string): email subject
             * @param message (string): email message
             * @param is_test (boolean): check if the email is sent for testing purposes
             */
            function sendWPMail($email_to,
                                $email_from,
                                $email_reply,
                                $email_name,
                                $subject,
                                $message,
                                $is_test = false){
                global $DOPBSP;
                
                $headers = array();
                
                array_push($headers, 'Content-type: text/html; charset=utf-8'."\r\n");
                array_push($headers, 'MIME-Version: 1.1'."\r\n");
                array_push($headers, 'From: '.$email_name.' <'.$email_from.'>'."\r\n");
                array_push($headers, 'Reply-To: '.$email_name.' <'.$email_reply.'>');
        
                if (!wp_mail($email_to, $subject, $message, implode('', $headers))){
                    if ($is_test){
                        echo $DOPBSP->text('SETTINGS_NOTIFICATIONS_TEST_ERROR');
                        die();
                    }
                    else{
                        $this->sendMail($email_to,
                                        $email_from,
                                        $email_reply,
                                        $email_name,
                                        $subject,
                                        $message);
                    }
                }
                else{
                    if ($is_test){
                        echo 'success';
                        die();
                    }
                }
            }
            
            /*
             * Test notification methods.
             * 
             * @post id (string): calendar ID
             * @post method (string): the method used to send the email
             *                        "mail" send email with PHP mail function
             *                        "mailer" send email with Mailer
             *                        "smtp" send email with SMTP
             *                        "wp" send email with WordPress mail function
             * @post email (string): receiver email
             */
            function test(){
                global $wpdb;
                global $DOPBSP;
                
                $id = $_POST['id'];
                $method = $_POST['method'];
                $email = $_POST['email'];
                
                $settings_notifications = $wpdb->get_row($wpdb->prepare('SELECT * FROM '.$DOPBSP->tables->settings_notifications.' WHERE calendar_id=%d', 
                                                                        $id));
                $email_reply = $settings_notifications->email_reply == '' ? $settings_notifications->email:$settings_notifications->email_reply;
                $email_name = $settings_notifications->email_name == '' ? $settings_notifications->email_reply:$settings_notifications->email_name;
                
                $this->send($email,
                            $settings_notifications->email,
                            $email_reply,
                            $email_name,
                            $DOPBSP->text('SETTINGS_NOTIFICATIONS_TEST_'.strtoupper($method).'_SUBJECT'),
                            $DOPBSP->text('SETTINGS_NOTIFICATIONS_TEST_'.strtoupper($method).'_MESSAGE'),
                            $settings_notifications->smtp_host_name,
                            $settings_notifications->smtp_host_port,
                            $settings_notifications->smtp_ssl == 'true' ? 'ssl':'',
                            $settings_notifications->smtp_user,
                            $settings_notifications->smtp_password,
                            $method,
                            true);
            }
        }
    }