<?php

/*
* Title                   : Booking System PRO (WordPress Plugin)
* Version                 : 2.0
* File                    : views/dashboard/views-backend-dashboard-server.php
* File Version            : 1.0
* Created / Last Modified : 28 May 2014
* Author                  : Dot on Paper
* Copyright               : © 2012 Dot on Paper
* Website                 : http://www.dotonpaper.net
* Description             : Booking System PRO back end dashboard server views class.
*/

    if (!class_exists('DOPBSPViewsDashboardServer')){
        class DOPBSPViewsDashboardServer extends DOPBSPViewsDashboard{
            /*
             * Constructor
             */
            function DOPBSPViewsDashboardServer(){
            }
            
            /*
             * Returns dashboard system template.
             * 
             * @param args (array): function arguments
             *                      * server (array): server data
             * 
             * 
             * @return dashboard system HTML template
             */
            function template($args = array()){
                global $DOPBSP;
                
                $server = $args['server'];
?>
            <section class="content-wrapper">
                <div class="box-header hide">
                    <h3><?php echo $DOPBSP->text('DASHBOARD_SERVER_TITLE'); ?></h3>
                    <a href="javascript:DOPBSP.toggleBox('server')" id="DOPBSP-box-button-server" class="button"></a>
                </div>
                <div id="DOPBSP-box-server" class="box-wrapper">
                    <table id="DOPBSP-server">
                        <colgroup>
                            <col />
                            <col />
                            <col />
                            <col />
                        </colgroup>
                        <thead>
                            <tr>
                                <th></th>
                                <th><?php echo $DOPBSP->text('DASHBOARD_SERVER_REQUIRED'); ?></th>
                                <th><?php echo $DOPBSP->text('DASHBOARD_SERVER_AVAILABLE'); ?></th>
                                <th><?php echo $DOPBSP->text('DASHBOARD_SERVER_STATUS'); ?></th>
                            </tr>
                        </thead>
                        <tbody>
<?php
                for ($i=0; $i<count($server); $i++){
?>
                            <tr class="<?php echo $i%2 == 0 ? 'odd':'even'; ?>">
                                <td><?php echo $server[$i]['title']; ?></td>
                                <td><?php echo $server[$i]['required']; ?></td>
                                <td><?php echo $server[$i]['available']; ?></td>
                                <td><span class="icon <?php echo $server[$i]['icon']; ?>"></span></td>
                            </tr>
<?php
                }
?>
                        </tbody>
                    </table>
                </div>
            </section>
<?php
            }
        }
    }