<?php
/**
 * This file is used for your video post entry
 * @package Thoughts WordPress Theme
 * @since 1.0
 * @author AJ Clarke : http://wpexplorer.com
 * @copyright Copyright (c) 2012, AJ Clarke
 * @link http://wpexplorer.com
 * @license http://www.gnu.org/licenses/old-licenses/gpl-2.0.html
 */  
?>

<?php wpex_hook_content_before(); ?>
<article <?php post_class('post-entry clearfix'); ?>> 
<?php wpex_hook_content_top(); ?> 

	<div class="post-entry-video fitvids">
		<?php echo wp_oembed_get( get_post_meta( get_the_ID(), 'wpex_post_video', true ) ); ?>
	</div><!-- /blog-entry-thumbnail -->
    
	<?php
	/**
	 * Single Posts
	 * @since 1.0
	 */
	if ( is_singular() && is_main_query() ) { ?>
        <div class="post-entry-text clearfix">
            <header>
                <h1><?php the_title(); ?></h1>
                <ul class="post-entry-meta">
                    <li><?php echo get_the_date(); ?></li>
                    <li>By: <?php the_author_posts_link(); ?></li>
                </ul>
            </header>
            <div class="post-entry-content">
            	<?php the_content(''); ?>
            </div><!-- /post-entry-content -->
            <footer class="post-entry-footer">
                <p><?php _e('Categorized','wpex'); ?>: <?php the_category(' - '); ?></p>
                <p><?php _e('Tagged','wpex'); ?>: <?php the_tags('',' - ', ''); ?></p>
            </footer><!-- /post-entry-footer -->
            <?php comments_template(); ?>
        </div><!-- /post-entry-text -->
    <?php
	/**
	 * Entries
	 * @since 1.0
	 */
	} else { ?>
        <div class="post-entry-text clearfix">
            <header>
                <h2><a href="<?php the_permalink(); ?>" title="<?php the_title(); ?>"><?php the_title(); ?></a></h2>
                <ul class="post-entry-meta">
                    <li><?php echo get_the_date(); ?></li>
                    <li>By: <?php the_author_posts_link(); ?></li>
                </ul>
            </header>
            <div class="post-entry-content">
            	<?php the_content(''); ?>
            </div><!-- /post-entry-content -->
            <footer class="post-entry-footer">
                <?php if(comments_open()) { ?><?php comments_popup_link(__('0 Comments', 'wpex'), __('1 Comment', 'wpex'), __('% Comments', 'wpex'), 'comments-link' ); ?><?php } ?><span class="wpex-icon-minus"></span><a href="<?php the_permalink(); ?>" title="<?php _e('read more','wpex'); ?>"><?php _e('read more','wpex'); ?> &rarr;</a>
            </footer><!-- /post-entry-footer -->
        </div><!-- /post-entry-text -->  
    <?php } ?>    
    
<?php wpex_hook_content_bottom(); ?>
</article><!-- /post-entry -->
<?php wpex_hook_content_after(); ?>